<?php namespace App\Controllers\Api\Ipn;

use App\Controllers\BaseController;
use App\Libraries\Uid;
use App\Models\AppsModel;
use App\Libraries\Settings;
use App\Models\DepositMethodsModel;
use App\Models\PlansModel;
use App\Models\SubscribesModel;
use App\Models\TransactionsModel;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Database\Exceptions\DatabaseException;

class PayPal extends BaseController
{
    public function index(): ResponseInterface
    {
        $methods = new DepositMethodsModel();
        $method = $methods->where([
            "name" => "PayPal",
            "status" => 1
        ])->first();

        if (!$method) {
            return $this->respond(["message" => lang("Message.message_84")], 400);
        }

        $payload = @file_get_contents('php://input');
        $client = service('curlrequest');
        $paypalUrl = 'https://api.paypal.com/v1/notifications/verify-webhook-signature'; // Đổi từ sandbox sang live

        try {
            $clientId = $method["api_value_1"];
            $clientSecret = $method["api_value_2"];
            $auth = base64_encode("$clientId:$clientSecret");
            $response = $client->post($paypalUrl, [
                'headers' => [
                    'Authorization' => "Basic $auth",
                    'Content-Type' => 'application/json'
                ],
                'json' => [
                    'transmission_id' => $_SERVER['HTTP_PAYPAL_TRANSMISSION_ID'],
                    'transmission_time' => $_SERVER['HTTP_PAYPAL_TRANSMISSION_TIME'],
                    'cert_url' => $_SERVER['HTTP_PAYPAL_CERT_URL'],
                    'auth_algo' => $_SERVER['HTTP_PAYPAL_AUTH_ALGO'],
                    'transmission_sig' => $_SERVER['HTTP_PAYPAL_TRANSMISSION_SIG'],
                    'webhook_id' => $method["api_value_3"],
                    'webhook_event' => json_decode($payload, true)
                ]
            ]);

            $verification = json_decode($response->getBody(), true);

            if ($verification['verification_status'] !== 'SUCCESS') {
                throw new DatabaseException("Invalid webhook signature");
            }
        } catch (\Exception $e) {
            return $this->respond(["message" => $e->getMessage()], 400);
        }

        $event = json_decode($payload, true);
        $subscribes = new SubscribesModel();
        $uid = new Uid();
        $db = \Config\Database::connect();
        $db->transStart();

        try {
            switch ($event['event_type']) {
                case 'BILLING.SUBSCRIPTION.CREATED':
                    $plan_id = $event['resource']['custom_id'];
                    $user_id = $event['resource']['subscriber']['payer_id'];
                    $app_id  = $event['resource']['custom_id'];
                    $amount_total = $event['resource']['amount_with_breakdown']['gross_amount']['value'];

                    $plans = new PlansModel();
                    $plan = $plans->where("id", $plan_id)->select("count")->first();

                    $currentDate = date('Y-m-d');
                    $newDate = date('Y-m-d', strtotime('+'.$plan['count'].' month', strtotime($currentDate)));

                    $subscribes->insert([
                        "subscribe_external_id" => $event['resource']['id'],
                        "customer_external_id"  => $event['resource']['subscriber']['payer_id'],
                        "plan_id"               => $plan_id,
                        "user_id"               => $user_id,
                        "expires_at"            => strtotime($newDate),
                        "app_id"                => $app_id,
                        "price"                 => $amount_total,
                        "uid"                   => $uid->create(),
                        "is_active"             => 1,
                        "method_id"             => $method['id']
                    ]);

                    $projects = new AppsModel();
                    $projects->update($app_id, ["status" => 1]);

                    break;
                case 'PAYMENT.SALE.COMPLETED':
                    $subscribe_external_id = $event['resource']['billing_agreement_id'];
                    $expires_at = strtotime($event['resource']['billing_agreement_details']['next_billing_date']);
                    $amount_paid = $event['resource']['amount']['total'];
                    $invoice_id = $event['resource']['id'];

                    $subscribe = $subscribes->where("subscribe_external_id", $subscribe_external_id)->select("id")->first();

                    if ($subscribe) {
                        $subscribes->update($subscribe["id"], ["expires_at" => $expires_at]);
                    }

                    $transactions = new TransactionsModel();
                    $transactions->insert([
                        "uid" => $uid->create(),
                        "amount" => $amount_paid,
                        "status" => 1,
                        "method_id" => $method['id'],
                        "subscribe_external_id" => $subscribe_external_id,
                        "external_uid" => $invoice_id
                    ]);

                    break;
                case 'CHECKOUT.ORDER.APPROVED':
                    // Handle CHECKOUT.ORDER.APPROVED event
                    break;
                case 'PAYMENT.CAPTURE.COMPLETED':
                    $customID = $event['resource']['custom_id'];
                    $customValues = explode("_", $customID);

                    $plan_id = $customValues[0];
                    $user_id = $customValues[1];
                    $app_id  = $customValues[2];

                    $plans = new PlansModel();
                    $plan = $plans->where("id", $plan_id)->select("count,price")->first();
                    $amount_total = $plan["price"];
                    $currentDate = date('Y-m-d');
                    $newDate = date('Y-m-d', strtotime('+'.$plan['count'].' month', strtotime($currentDate)));

                    $subscribes->insert([
                        "subscribe_external_id" => $event['resource']['id'],
                        "customer_external_id"  => $event['resource']['id'],
                        "plan_id"               => $plan_id,
                        "user_id"               => $user_id,
                        "expires_at"            => strtotime($newDate),
                        "app_id"                => $app_id,
                        "price"                 => $amount_total,
                        "uid"                   => $uid->create(),
                        "is_active"             => 1,
                        "method_id"             => $method['id']
                    ]);

                    break;
                default:
                    // Unhandled event type
            }

            $db->transComplete();
            return $this->respond(["status" => "ok"], 200);
        } catch (\Exception $e) {
            $db->transRollback();
            return $this->respond(["message" => $e->getMessage()], 400);
        }
    }

    public function capture(): ResponseInterface
    {
        try {
            $methods = new DepositMethodsModel();
            $method = $methods->where([
                "name" => "PayPal",
                "status" => 1
            ])->first();

            if (!$method) {
                return $this->respond(["message" => lang("Message.message_84")], 400);
            }
            $clientId = $method["api_value_1"];
            $clientSecret = $method["api_value_2"];
            $auth = base64_encode("$clientId:$clientSecret");
            $orderId = $this->request->getGet('token');
            $paypalUrl = 'https://api.paypal.com/v2/checkout/orders'; // Đổi từ sandbox sang live
            $client = service('curlrequest');
            $response = $client->post("$paypalUrl/{$orderId}/capture", [
                'headers' => [
                    'Authorization' => "Basic $auth",
                    'Content-Type' => 'application/json',
                ]
            ]);

            if ($response->getStatusCode() != 201) {
                throw new \Exception("Failed to capture PayPal order");
            }

        } catch (\Exception $e) {
            log_message('error', 'PayPal Capture Error: ' . $e->getMessage());
            return $this->respond(["message" => $e->getMessage()], 400);
        }
        $settings = new Settings();
        $frontUrl = $settings->get_config("site_url");
        return redirect()->to($frontUrl.'private/profile/subscribe');
    }
}